function [P_und,tmap] = RABT_Fundistort(P,fl,k1,tmap_folder,tmapav,orientation)
% RABT_Fundistort
% 
% Author: Koen Hilgersom (2011)
% 01/07/2011
%
% Function file is run by the script 'Rising Air Bubble Technique_vX_X.m'
%
% This function loads or creates a transformation matrix and uses this to
% undistort the input picture. The output is the undistorted picture and
% the used transformation matrix.
%
% Input
% P             -    Input picture
% fl            -    Focal length
% k1            -    Undistortion factor
% tmap_folder   -    Folder in which transformation matrices are saved
%                       (also specifying the camera and the lens)
% tmapav        -    Is there already a transformation matrix?
% 
% Output
% P_und         -    Undistorted picture
% tmap          -    Loaded or created transformation matrix
%
%---------------------------------------------------------------------------  
%      Copyright (C) 2011 Technische Universiteit Delft, 
%          Koen Hilgersom
%          K.P.Hilgersom@tudelft.nl (correspondence)
% 
%---------------------------------------------------------------------------  

%% preparation transformation matrix

if tmapav==0     % transformation matrix does not exist, make new
    disp('Create new transformation matrix for undistortion')
    S=solve(['y = x + ' num2str(k1) '*x^3']);
    S=matlabFunction(S(1)); % function for radial undistortion
    xmid = (size(P,2)+1)/2; % find index of middle element
    ymid = (size(P,1)+1)/2; % find index of middle element
    [nrows,ncols] = size(P(:,:,1));
    [xi,yi] = meshgrid(1:ncols,1:nrows);
    xt = xi(:) - xmid;
    yt = yi(:) - ymid;
    [theta,r] = cart2pol(xt,yt);
    rn=r/max(r);
    sn=S(rn);
    [ut,vt] = pol2cart(theta,sn);
    clear r rn sn theta S xi yi
    u = reshape(ut,[nrows ncols])/ut(end)*max(xt) + xmid;
    v = reshape(vt,[nrows ncols])/vt(end)*max(yt) + ymid;
    tmap = cat(3,u,v);

else
    %load existing tmap
    disp('Load existing transformation matrix')
    load([tmap_folder '\' num2str(fl) 'mm_' orientation '.mat']);
end

%% undistort
P_und=[];
if isnan(sum(sum(P)))==0
    resamp = makeresampler('linear','bound');
    P_und = tformarray(P,[],resamp,[2 1],[1 2],[],tmap,[0;0;0]);
    clear nrows ncols xt yt ut vt u v xmid ymid
end